# J-20-A-and-C Enhancement Pack 2025.08 Release Notes

## 🛠️ Bug Fixes
* Fixed bug where the cannon would fire all rounds at once (introduced in 2025.07).  
* Objects in helmet display no longer disappear in day/night mode.  
* Corrected positions of backlight and floodlight knobs.  
* Fixed HUD attitude scale overflow issue (resolved via separate page and layer clipping).  

---

## 🚀 New Features

### 🎮 General Key Bindings
* Cannon mode toggle, cannon mode button, cannon mode on, cannon mode off.  
* Day/night mode toggle, day mode on, night mode off.  
* Master weapon toggle, master weapon on, master weapon off.  
* Backlight and floodlight key bindings.  
* UFCP On (full bright), UFCP Off (full dark).  
* HUD On (full bright), HUD Off (full dark), HUD brightness axis.  
* MFCD brightness knob.  

---

### 🤖 Automation
* When hot start occurs between 18:00–06:00:  
  * Automatically turn on backlight and floodlight.  
  * Automatically switch to night mode.  
  * Automatically set helmet brightness to low.  

---

### 🪖 Helmet-Mounted Display (HMD)

#### 📶 RWR Signal Projection
* Three status icons:  
  * Search: purple square.  
  * Lock: 45° rotated red square inside search box.  
  * Launch: red ring surrounding lock box.  
* Signal source ID text above icon; status text below.  
* Icons and text flash in launch state.  
* Right-side vertical 5-segment white signal strength bar.  
* Can display RWR sources behind helmet (180°) with yellow “Rear” label.  
* Top 5 high-priority RWR targets highlighted (no friend/foe distinction).  

#### 🧠 Clustering & Anti-Jamming
* acmLock and BVR lock now use clustered targets.  
* Radar targets replaced with filtered and sorted clustered targets for improved anti-jamming and performance.  

#### 🧭 Situational Awareness
* Display target relative heading and ground speed.  
* Connect lines only to nearest 5 targets.  
* “Rear” label added for rear-facing targets.  

#### 📍 Navigation Point Display
* In navigation mode, distinguish between waypoints and landing points.  
* In ground attack mode, distinguish between waypoints and attack points.  
* “Rear” label added for rear-facing navigation points.  

#### 🎯 Lock Interaction & Animation
* NCTR text for candidate lock targets turns white when in range.  
* In BVR mode, can select target to lock by pointing helmet and pressing TMS down.  

---

### 🧑‍💻 HUD
* Normalized angle algorithm eliminates waypoint jump.  
* Layout optimized for readability and consistency.  

---

### 📡 Radar System
* Increased target echo preprocessing limit for better ECM resistance and performance.  
* Major radar code refactor (especially helmet target and acmLock process) for precise lock in all attitudes.  
* Roll maneuver optimization: even beyond 90°, MFD lock and helmet radar direction display correctly.  

---

### 💣 Weapon System
* Added CM-102A anti-radiation missile support (thanks to Bilibili user 麻辣兔兔柚 for weapon pack).  
* Updated weapon launch logic to allow manual CM-102A launch.  
* Updated MFD and weapon display layouts to integrate CM-102A.  
* Top bar only shows weapon stations with ammo > 0.  
* Updated pylon selection rules to prioritize external pylons.  
* Fixed missile negative drag and negative weight issues.  

---

## 🧪 Development & Debug Enhancements
* `utils.lua` now includes `Get_command_name` function for retrieving command names without interference.  
* `utils.lua` adds `Normalize_angle` algorithm.  

---

## ⚠️ Known Issues & Solutions
* VR devices may crash due to too many objects being rendered silently:  
  - By default, disable numbers on MFD EADI speed/altitude scales, EHSI scale bars, and airport markers.  
  - When not using VR, switch mode in secondary display settings (VR/Non-VR) to re-enable these elements.  
  - Caution: In VR, enable at your own risk.  
* Current MP3 list references non-existent songs, causing log errors:  
  - Added “Enable MP3Player” option in aircraft editor; disabled by default.  
* “Enable NGV” option has no effect:  
  - Aircraft already has low-light NVG; option removed.  

---

# J-20-A-and-C Enhancement Pack 2025.07

## 🔧 System Optimizations
* **FLIR Display Fix**: J-20C now correctly displays FLIR page.  
* **Wide-Angle WACQ Mode Enhancement**: Scan range increased to 20 NM; animations updated for wide-angle and long-aperture modes.  
* **Helmet IR Lock Ring Fix**: WeaponSystem code fix restores correct IR lock inner ring and lock animation.  

---

## 🎮 Display & UI Updates
* **Auxiliary Screen Stability**: Exiting AA/AG mode now returns to main menu to avoid VR crashes.  
* **New VR/Non-VR Display Mode Option**: Added OSB6 toggle in secondary display settings; VR mode default for stability.  
* **Radar Target Processing**: Now supports >15 radar targets.  

---

## ⚔️ Weapon System Upgrades
* **Mission Editor Loadout Page**: PL-17 replaced with PL-15 model when mounted to avoid clipping; reverts after launch.  
* **Weapon Switching Logic**: Skips empty pylons and invalid missiles automatically.  
* **DLZ & TOF Implementation**:  
  - **TOF**: Track up to 6 launched missiles with countdown on MFD Top page; HUD/HMD show clock-style indicator.  
  - **DLZ**: STT lock shows target distance dot moving around lock box edges according to range.  

---

## 👁 HUD & HMD Enhancements
* **Master Arm SAFE Display**: HUD/HMD show SAFE status.  
* **HUD New Data**: Added true airspeed and vertical climb rate.  
* **STT Lock Layout Optimization**: Clearer HUD/HMD lock info.  
* **HUD Angle Calibration**: Seamless HUD-HMD transition.  
* **VACQ Mode Update**: Range updated to 8° × 90°.  

---

## 🛠️ Debug Layer Optimization
* **Helmet Debug Info**: Moved to separate page layer; controlled by `Render_debug_info`.  
* **HUD Debug Info**: Unified with helmet debug logic.  

---

# J-20-A-and-C Enhancement Pack 2025.06

## 🛫 Canopy & View Optimization
* **Canopy Upgrade**: New transparent, high-clarity design.  
* **Default View Adjustment**: Centered default view.  

---

## 🎨 Material & Input Binding Optimization
* **Material Update**: Alpha channel version for better performance and no log warnings.  
* **Input Binding Fixes**: Improved joystick/throttle bindings.  

---

## 🧩 Model & Function Enhancements
* **Model Parameter Adjustments**: Some based on F-22.  
* **Quaternion Functions**: Added for better spatial calculations.  
* **Debug Output Function**: Added `Log_and_print`.  
* **Extra Handle Support**: Many new handles added.  

---

## 💣 Weapon Mount Enhancements
* **PL-17**: Added single and fictional 4-round bay versions.  
* **PL-15**: Added fictional 2-round bay version.  
* **PL-10E**: Added fictional 4-round bay version.  
* **Independent Master Arm Binding**.  
* **Display Improvements**: Ammo counts shown on HUD/HMD/MFD.  

---

## 📡 Radar System Rework
* **ACM Lock Rewrite**: All radar modes stabilized except WACQ.  
* **Tracking Improvements**: More accurate with attitude changes.  
* **Auto-Lock Optimization**: Locks nearest target.  
* **Lock Speed**: Reduced to 0.4–0.8s.  
* **New HACQ Mode**: 50 NM range, 120° × 10° scan.  
* **BST Mode Adjustment**: 5° × 5° scan.  

---

## 🖥️ MFD Radar & EHSI Enhancements
* **BVR & ACM Display Optimization**.  
* **Unit Switch Fix**.  
* **BST Mode Display Improvements**.  
* **Post-Lock Display Optimization**: Correct colors, scaling, and NCTR data.  

---

## 🪖 Helmet Enhancements
* **Target Display**: Red for hostile, yellow for unknown, green for friendly.  
* **Target Filtering & Clustering**: Blue border for clustered targets.  
* **BST Mode Aim Fix**.  

---

## 🎯 HUD Improvements
* **Helmet Effects Extended to HUD**.  
* **Text Layout & Font Adjustments**.  
* **Dynamic Gunsight**.  
* **HACQ Mode Reference Lines**.  
* **HUD Angle Calibration**.  

---

## ✈️ J-20A Updates
* **Internal Cannon Added**.  

---

## ⛔ Disabled Features
* **Simplified EHSI**: Removed airport and detailed heading scale in VR to prevent crashes.  

---

## ⚠️ Known Issues
* **Aux Screen Crash in VR**: Exit cruise mode before switching to E
